create table koca_mngif_access_app
(
   app_key              varchar(400) not null comment 'APPKEY',
   app_security         varchar(500) not null comment '安全码',
   app_name             varchar(200) comment '应用名称',
   limit_type           varchar(32) default '1' comment '限制方式 1：白名单 2：黑名单',
   enabled              varchar(32) default '0' comment '是否可用 1：可用 0：不可用',
   app_desc             varchar(800) comment '应用描述',
   creator              varchar(65) comment '创建人',
   modify_oper          varchar(65) comment '修改人',
   create_time          varchar(32) comment '创建时间',
   modify_time          varchar(32) comment '修改时间',
   primary key (app_key)
);

/*==============================================================*/
/* Table: KOCA_MNGIF_API_AUTH                                           */
/*==============================================================*/
create table koca_mngif_api_auth
(
   app_key              varchar(400) not null comment 'appkey',
   api_code             varchar(64) not null comment '接口代码',
   primary key (app_key, api_code)
);

/*==============================================================*/
/* Table: KOCA_MNGIF_BLACK_WHITE_LIST                                   */
/*==============================================================*/
create table koca_mngif_black_white_list
(
   id                   numeric(8,0) not null comment '主键',
   ip_adress            varchar(300) not null comment 'ip地址',
   app_key              varchar(400) not null comment 'appkey',
   creator              varchar(65) comment '创建人',
   modify_oper          varchar(65) comment '修改人',
   create_time          varchar(32) default 'SYSDATE' comment '创建时间',
   modify_time          varchar(32) default 'SYSDATE' comment '修改时间',
   primary key (id)
);


/*==============================================================*/
/* table: koca_mngif_api_interface                                      */
/*==============================================================*/
create table koca_mngif_api_interface
(
   api_code             varchar(100) comment 'api 接口代码',
   api_name             varchar(400) comment 'api 接口名称',
   api_desc             varchar(4000) comment 'api 接口描述',
   api_type             varchar(16) comment 'http 请求类型',
   api_uri              varchar(400) comment 'api 接口uri',
   create_time          TIMESTAMP(6) comment 'api 创建时间',
   primary key (api_code)
);

alter table koca_mngif_api_interface comment 'api 接口';

create table seqapi 			 
(
   id int(11) not null auto_increment,
   primary key (id)
);