﻿/*==============================================================*/
/* Table: KOCA_SYS_DICTIONARY                                        */
/*==============================================================*/
create table koca_sys_dictionary
(
   dict_code            varchar(32) not null,
   dict_name            varchar(128),
   dict_type            varchar(2),
   maintain_flag        varchar(16),
   remark               varchar(128),
   tenant_id            varchar(32),
   primary key (dict_code)
);

/*==============================================================*/
/* Table: koca_sys_dictionary_i18n                                   */
/*==============================================================*/
create table koca_sys_dictionary_i18n
(
   dict_code            varchar(32) not null comment '字典编码',
   language_type        varchar(32) not null comment '语言类型',
   dict_name            varchar(256) comment '字典名称',
   primary key (dict_code, language_type)
);

alter table koca_sys_dictionary_i18n comment '字典国际化表';

/*==============================================================*/
/* Table: koca_sys_dictionary_item                                   */
/*==============================================================*/
create table koca_sys_dictionary_item
(
   dict_code            varchar(32) not null,
   org_code             varchar(8) not null,
   dict_item            varchar(32) not null,
   dict_item_name       varchar(128),
   dict_ord             numeric(8,0),
   remark               varchar(128),
   primary key (dict_code, org_code, dict_item)
);

/*==============================================================*/
/* Table: koca_sys_dictionary_item_i18n                              */
/*==============================================================*/
create table koca_sys_dictionary_item_i18n
(
   dict_code            varchar(32) not null comment '字典编码',
   org_code             varchar(8) not null comment '机构编码',
   dict_item            varchar(32) not null comment '字典项',
   dict_item_name       varchar(128) comment '字典项名称',
   language_type        varchar(32) not null comment '语言类型',
   primary key (dict_code, org_code, dict_item, language_type)
);

alter table koca_sys_dictionary_item_i18n comment '字典项国际化';

/*==============================================================*/
/* Table: koca_sys_menu                                              */
/*==============================================================*/
create table koca_sys_menu
(
   menu_id              varchar(10) not null comment '菜单编号',
   menu_status          varchar(2) comment '菜单状态',
   menu_type            varchar(2) comment '菜单类型',
   menu_name            varchar(64) comment '菜单名称',
   menu_url             varchar(256) comment '菜单链接',
   parent_menu          varchar(10) comment '父菜单',
   prev_menu            varchar(10) comment '同级前菜单',
   menu_icon            varchar(32) comment '菜单图标',
   load_type            varchar(2) comment '加载类型',
   remark               varchar(128) comment '备注信息',
   tenant_id            varchar(32) comment '租户编号',
   permission_alias   varchar(32) comment '按钮权限',
   primary key (menu_id)
);

/*==============================================================*/
/* Table: KOCA_SYS_MENU_I18N                                         */
/*==============================================================*/
create table koca_sys_menu_i18n
(
   menu_id              varchar(10) not null comment '菜单ID',
   menu_name            varchar(64) comment '菜单名称',
   language_type        varchar(32) not null comment '语言类型',
   primary key (menu_id, language_type)
);

alter table koca_sys_menu_i18n comment '菜单国际化表';

/*==============================================================*/
/* Table: KOCA_SYS_PARAMETER                                         */
/*==============================================================*/
create table koca_sys_parameter
(
   par_code             varchar(32) not null,
   par_name             varchar(256),
   par_type             varchar(2),
   par_type_sub         varchar(2),
   maintain_flag        varchar(2),
   remark               varchar(128),
   tenant_id            varchar(32),
   primary key (par_code)
);

/*==============================================================*/
/* Table: koca_sys_parameter_i18n                                    */
/*==============================================================*/
create table koca_sys_parameter_i18n
(
   par_code             varchar(32) not null comment '参数编码',
   language_type        varchar(32) not null comment '语言类型',
   par_name             varchar(256) comment '参数名称',
   primary key (par_code, language_type)
);

alter table koca_sys_parameter_i18n comment '参数国际化表';

/*==============================================================*/
/* Table: koca_sys_parameter_val                                     */
/*==============================================================*/
create table koca_sys_parameter_val
(
   par_code             varchar(32) not null,
   org_code             varchar(8) not null,
   par_val              varchar(256),
   primary key (par_code, org_code)
);

/*==============================================================*/
/* Table: koca_sys_parameter_val_i18n                                */
/*==============================================================*/
create table koca_sys_parameter_val_i18n
(
   par_code             varchar(32) not null comment '参数编码',
   org_code             varchar(8) not null comment '机构编码',
   language_type        varchar(32) not null comment '语言类型',
   par_val              varchar(256) comment '参数值',
   primary key (par_code, org_code, language_type)
);

alter table koca_sys_parameter_val_i18n comment '参数值国际化表';

create table koca_sys_calendar
(
   calendar_date            varchar(64) not null,
   calendar_type            varchar(32) not null,
   calendar_sign            varchar(8),
   remark               varchar(128),
   primary key (calendar_date,calendar_type)
);