﻿/*==============================================================*/
/* DBMS name:      MySQL 5.0                                    */
/* Created on:     2020/1/15 16:06:15                           */
/*==============================================================*/



/*==============================================================*/
/* Table: koca_menu_api                                              */
/*==============================================================*/
create table koca_menu_api
(
   menu_id              varchar(10) not null comment '菜单编号',
   api_code             varchar(100) not null comment 'API接口代码',
   resource_url         varchar(255) comment '接口请求路径',
   primary key (api_code)
);

alter table koca_menu_api comment '菜单API信息表';

/*==============================================================*/
/* Table: koca_org_info_base                                         */
/*==============================================================*/
create table koca_org_info_base
(
   org_code             varchar(8) not null comment '机构代码',
   org_status           varchar(2) comment '机构状态，字典，ORG_STATUS',
   org_type             varchar(8) comment '机构类型，字典，ORG_TYPE',
   parent_org           varchar(8) comment '上级机构',
   org_name             varchar(32) comment '机构名称',
   org_full_name        varchar(64) comment '机构全称',
   address              varchar(64) comment '机构地址',
   zip_code             varchar(6) comment '机构邮编',
   tel                  varchar(16) comment '机构电话',
   remark               varchar(128) comment '备注信息',
   primary key (org_code)
);

/*==============================================================*/
/* Table: koca_org_info_ext                                          */
/*==============================================================*/
create table koca_org_info_ext
(
   org_code             varchar(8) not null comment '机构代码，主键',
   org_key              varchar(16) comment '信息key，字典，ORG_KEY',
   org_value            varchar(128) comment '信息value',
   primary key (org_code)
);

/*==============================================================*/
/* Table: koca_role_info                                             */
/*==============================================================*/
create table koca_role_info
(
   role_no              varchar(8) not null comment '角色编号',
   role_name            varchar(32) comment '角色名称',
   role_type            varchar(2) comment '角色类型',
   role_status          varchar(2) comment '角色状态',
   remark               varchar(128) comment '描述',
   primary key (role_no)
);

alter table koca_role_info comment '角色信息表';

/*==============================================================*/
/* Table: koca_user_info_base                                        */
/*==============================================================*/
create table koca_user_info_base
(
   user_no              varchar(32) not null comment '人员编号',
   user_type            varchar(2) not null comment '人员类型，字典USER_TYPE',
   user_status          varchar(2) not null comment '人员状态,字典USER_STATUS',
   user_code            varchar(32) not null comment '人员代码',
   user_name            varchar(32) not null comment '姓名',
   id_type              varchar(2) not null comment '证件类型',
   id_code              varchar(32) not null comment '证件号码',
   id_iss_agcy          varchar(64) comment '发证机关',
   id_address           varchar(128) comment '证件地址',
   id_begin_date        varchar(8) comment '证件开始日期',
   id_exp_date          varchar(8) comment '证件结束日期',
   birthday             varchar(8) comment '出生日期',
   sex                  varchar(2) comment '性别,字典，SEX',
   nationality          varchar(2) comment '民族,字典',
   citizenship          varchar(3) comment '国籍,字典',
   education            varchar(2) comment '学历，字典',
   native_place         varchar(32) comment '籍贯',
   mobile_tel           varchar(11) comment '手机号码',
   email                varchar(32) comment '邮箱',
   address              varchar(128) comment '联系地址',
   zip_code             varchar(6) comment '邮政编码',
   user_icon            varchar(255) comment '用户头像',
   create_date          varchar(8) comment '注册日期',
   cancel_date          varchar(32) comment '注销日期',
   remark               varchar(128) comment '备注信息',
   oper_ext_attr        varchar(16) default '0',
   primary key (user_no)
);

/*==============================================================*/
/* table: koca_user_info_ext                                         */
/*==============================================================*/
create table koca_user_info_ext
(
   user_no              varchar(32) not null comment '人员编号',
   user_key             varchar(16) not null comment '信息key，字典USER_KEY',
   user_value           varchar(128) comment '信息value',
   primary key (user_no, user_key)
);

/*==============================================================*/
/* table: koca_user_opt_log                                          */
/*==============================================================*/
create table koca_user_opt_log
(
   s_no                 int(8) not null,
   begin_time           datetime,
   end_time             datetime,
   user_no              varchar(32),
   opt_code             varchar(64),
   opt_data             text,
   res_status           varchar(8),
   res_message          varchar(128),
   res_code             varchar(8),
   remark               varchar(128),
   primary key (s_no)
);

/*==============================================================*/
/* table: koca_user_org_info                                         */
/*==============================================================*/
create table koca_user_org_info
(
   org_code             varchar(8) not null comment '机构代码，主键',
   user_no              varchar(32) not null,
   primary key (user_no)
);

/*==============================================================*/
/* table: koca_user_pwd                                              */
/*==============================================================*/
create table koca_user_pwd
(
   user_no              varchar(32) not null,
   pwd                  varchar(64),
   pwd_status           varchar(2),
   update_time          datetime,
   remark               varchar(128),
   wrong_time integer(8) default 0,
   primary key (user_no)
);

/*==============================================================*/
/* table: koca_user_pwd_log                                          */
/*==============================================================*/
create table koca_user_pwd_log
(
   sno                  int(11) not null,
   user_no              varchar(32),
   pwd                  varchar(64),
   set_date             datetime,
   primary key (sno)
);

/*==============================================================*/
/* table: koca_user_role_info                                        */
/*==============================================================*/
create table koca_user_role_info
(
   user_no              varchar(32) not null comment '人员编号',
   role_no              varchar(8) not null comment '角色编号',
   primary key (user_no, role_no)
);

alter table koca_user_role_info comment '人员角色信息表';

create table user_opt_log_no
(
   id                 int(8) not null auto_increment,
   primary key (id)
);

create table user_pwd_log_no
(
   id                 int(11) not null auto_increment,
   primary key (id)
);

create table koca_sys_password_parameter
(
   par_code             varchar(32) not null ,
   par_name           varchar(128) ,
   par_val             varchar(32) ,
   remark               varchar(128) comment '备注信息',
   primary key (par_code)
);

