/*==============================================================*/
/* Table: KOCA_PERM_MENU_ROLE                                        */
/*==============================================================*/
create table koca_perm_menu_role
(
   id                   varchar(32) not null,
   menu_id              varchar(10),
   role_no              varchar(8),
   right_type           varchar(2),
   grant_user           varchar(32),
   grant_time           varchar(16),
   primary key (id),
   key perm_role_unique_key (menu_id, role_no)
);

/*==============================================================*/
/* Table: koca_perm_menu_user                                        */
/*==============================================================*/
create table koca_perm_menu_user
(
   id                   varchar(32) not null,
   menu_id              varchar(10) not null,
   user_no              varchar(32) not null,
   right_type           varchar(2) not null,
   grant_user           varchar(32),
   grant_time           varchar(16),
   primary key (id),
   key perm_user_unique (menu_id, user_no)
);

create table koca_user_favorite_menu
(
   user_no                   varchar(32) not null,
   menu_id              varchar(10) not null,
   record_type              varchar(2) default '0',
   primary key (user_no, menu_id, record_type)
);

